//
//  MCMixedDataCellTableColumn.h
//  MCApplication
//
//  Created by Eric Hochmeister on 05/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

/*!
    @header MCMixedDataCellTableColumn
    @abstract   Allows delegate to control which cell a Tablecolumn will use when displaying
                a row
    @discussion overrides the dataCellForRow: method to allow the delegate to provide the custom cell
                to use
*/


#import <Cocoa/Cocoa.h>


@interface MCMixedDataCellTableColumn : NSTableColumn {

}

@end

@interface NSObject (MCMixedDataCellTableColumnDelegate)

// this method returns the cell which will be used by the tablecolumn for the row
- (id)dataCellForRow:(int)row column:(NSTableColumn*)aCol;

@end
